(load "terms.scm")
;(load "test.scm")
; RESERVED WORDS:
;   TRUE, FALSE, UNSET, SATISFIABLE
;


(define f_Satx 0)
(define f_Saty 0)
(define f_SATISFIED #f)
(define g_varList 0)
(define nowCost 0)
(define bestCost 0)

;Dr Scheme has a very unpleasant Display function
(define pp
  (lambda (x)
    (display x)
    (newline) 
    )
  )

;list - UNSET, TRUE, FALSE, VARIABLE_NAME, (NOT VARIABLE_NAME)
;variable name is required for displaying a truth value at the end of execution

;*******************************************************************************************HEURISTICS
(define depth 4)

; this does not run properly, because we are dealing with a list, and not a queue
; a queue would speed up execution significantly (I hope)
(define chooseNext 
  (lambda (prev open varList)
    (define n_open 0)
    (define inscope 0)
    (define next 0)
    (define rest '())
    (define break #f)
    (define isco_cost 0)
    (define next_cost 0)
    (set! n_open (getHead open depth))
    (set! inscope (car n_open))
    (set! next (car (car n_open)))
    (set! next_cost (noTermsLeft next varList))

    (do ((inscope (cdr (car n_open)) (cdr inscope))) ((null? inscope))
      (set! isco_cost (noTermsLeft(car inscope) varList))
      (if (< isco_cost next_cost)
          (begin
            (set! rest (cons next rest))
            (set! next (car inscope))
            (set! next_cost isco_cost)
          )
          (begin
            (set! rest (cons (car inscope) rest))
          )))
    (list 
      next 
      (append (car (cdr n_open)) rest)) 
        ;-> next, open, closed
  )
)

; overwrites the chooseNext
(define chooseNext 
  (lambda (prev open varList) 
    (list
     (car open)
     (cdr open))))

; splits the list into two sections, one of size (min n, sizeof ls) and the rest
(define getHead
  (lambda (ls n)
    (define outlist '())
    (define inlist 0)
    (set! inlist ls)
    (do ((count n (- count 1)) (break #f)) (break)
      (set! outlist (cons (car inlist) outlist))
      (set! inlist (cdr inlist))
      (set! break (or (< count 2) (null? inlist)))
      )
    (list outlist inlist)
    ))

; counts the number of terms that are unsigned in a clause
(define noTermsLeft
  (lambda (x varList)
    (apply + (map (noTermsLeft-m varList) x) ))   
)
; helper
(define noTermsLeft-m
  (lambda (varList)
    (lambda (x)
      (if (isUnset? (car x) varList) '1 '0)
      )))

; uncalled, and unworking code that is supposed to choose the variable that is most prevalent in the whole testcase
(define mostCommon
  (lambda (best first open varList)
    (pp (list 'O: (car (car open))))
    (pp (list 'F: first)) 
    (pp (list '$: open))
    
    (if (equal? first (car (car open)))
        (begin (pp "*********************************************************************************")
        (cons best open))
        (begin
          (set! nowCost (getValue (car (car open)) gVarCountList))
          (if (> nowCost bestCost)
              (begin
                (set! bestCost (getValue (car (car open)) gVarCountList)) 
                (mostCommon (car open) first (append (cdr open) (list best)) varList)
              )
            (mostCommon (car open) first (append (cdr open) (list (car open))) varList )
            )
        )
    )))
; see above
(define choosePath3
  (lambda (sat open) 
    (pp (list 'S: sat))
    (if (null? (cdr sat))
        sat
        (begin
          (set! bestCost (getValue (car (car sat)) gVarCountList))
          (pp (list (mostCommon (car sat) (car sat) (cdr sat) gVarCountList)))
          (set! bestCost 0)
          (mostCommon (car sat) (getValue (car (car sat))) (car sat) (cdr sat) varList)
        )
    )
  )
)
  
; choose the first satisfiable variable
(define choosePath
  (lambda (sat open)
    sat
    ))

; I should try and choose a path that leads to unSat being satisfiable
; else use the normal choosePath
(define chooseBPath
  (lambda (sat open unSat)
    sat
  )
)

;*******************************************************************************************ASSOCIATIVE LIST STUFF

;sets the cdr of an associative list
;breaks because it globally changes varList (which is bad for any kind of backtracking)
(define set!Value
  (lambda (x value varList)
    (set-cdr! (assq x varList) value)
    varList
  )
)

;sets the cdr of an associative list
;slower than set!Value because it recreates the list, but integrity of original varList is kept
(define setValue
  (lambda (x value varList)
    (map (setList (list x value)) varList)
  )
)

;needed for setValue
(define setList
  (lambda (x)
    (lambda (y)
      (if (eqv? (car y) (car x))
          x
          y
      )
    )
  )
)

;*******************************************************************************************UTILITY
(define PerTerm
  (lambda (x)
    (if (list? x) (list (car(cdr x)) #f) (list x #t))
  )
)

(define Rephrase-ORG
  (lambda (x)
    (if (null? x)
        '()
        (begin
          (cons (map PerTerm (cdr (car x))) (Rephrase (cdr x))) 
        )
    )
  )
)

(define Rephrase
  (lambda (x)
    (if (null? x)
        '()
        (begin
          (if (list? (car x)) 
              (if (eqv? (car (car x)) 'NOT) 
                  (cons (list (list (car(cdr(car x))) #f)) (Rephrase (cdr x)))
                  (cons (map PerTerm (cdr (car x))) (Rephrase (cdr x)))
              )
              (cons (list (car x) #t) (Rephrase (cdr x)))
          )
        )
    )
  )
)

(define changeO
  (lambda (x)
    (begin
    (if (eqv? (car (cdr x)) 'TRUE)
        (cons (car x) #t)
        (if (eqv? (car (cdr x)) 'FALSE)
                (cons (car x) #f)
                (if (eqv? (car (cdr x)) 'UNSET)
                    (cons (car x) #f)))))))

(define changeOutput
  (lambda (x)
    (if (not x)
        '#f
        (map changeO x)
    )
  )
)


;returns #t if TRUE or FALSE, else #f
(define isTRUEFALSE?
  (lambda (x varList)
    (define y '0)
    (set! y (cdr (assq x varList)))
    
    (if (eqv? 'TRUE (car y)) #t
        (if (eqv? 'FALSE (car y)) #t #f))
  )
)

(define isUnset? 
  (lambda (x varList)
    ;(pp x)
    ;(pp(getValue x varList))
    (eqv? 'UNSET (car(getValue x varList)))
  )
)

;returns #t if TRUE, #f is FALSE, UNSET if UNSET
(define returnTRUTH 
  (lambda (x)
    (case x
      ((TRUE SET-TRUE) #t)
      ((FALSE SET-FALSE) #f)
      ((UNSET) 'UNSET)
    )
  )
)

;slightly edited from www.scheme.com/tspl3/control.html's map function
; 1-D map that skips any 'empties' ie #void
(define mapish
  (lambda (f ls)
    (define x 0)
        (let map1 ((ls ls))
          (if (null? ls)
              '()
              (begin
                (set! x (f (car ls)))
                (if (list? x)
                    (cons x (map1 (cdr ls)))
                    (map1 (cdr ls))
                )
              )
          )
        )
  )
)

; returns the second element from x if first element is true, else return #void
(define iftrue
  (lambda (x)
    (if (eq? (car x) #t) (car (cdr x)))
  )
)

; returns the second element from x if first element is true, else return #void
(define iffalse
    (lambda (x)
    (if (eq? (car x) #f) (car (cdr x)))
  )
)


; updates the variable list, sets varlist(X to TRUE or FALSE)
(define updateVarList
  (lambda (ls varList)
    (if (car(cdr ls))
        (setValue (car ls) 'TRUE varList)
        (setValue (car ls) 'FALSE varList)
    )
  )
)
         
;gets the value from an associative list
(define getValue
  (lambda (x varList)
    ;(pp (list 'X: x)); varList))
    (cdr (assq x varList))   
  )
)

;*******************************************************************************************LOCAL SATISFIABILITY
; we do some things that go against everything Scheme stands for, but we speed things up versus isSatisfiable
; returns #f if ls is unsatisfiable
; returns #t if ls is satisfiable
; returns #t ls2 if ls is satisfiable if we choose one element of ls2
;can make faster by changing the order of (cons #t (mapish iftrue ls))
(define f_isSat
  (lambda (varList)
    (lambda (x)
      ;(pp (getValue (car x) varList))
      (set! f_Saty (returnTRUTH(car(getValue (car x) varList))))     
      (if (eqv? f_Saty 'UNSET) 
          x
          (begin
          (if (eq? f_Saty (car(cdr x)))
              (begin (set! f_SATISFIED #t) '())
              '()
          )
          )
      )
    )
  )
)

; 2-D map function that deals with the SATISFIED possibility to end
(define mapish2
  (lambda (f ls)
    (define z 0)
        (let map1 ((ls ls))
          (if (null? ls)
              '()
              (begin
                (set! z (f (car ls)))
                (if (null? z)
                    (if f_SATISFIED 
                        '() 
                        (map1 (cdr ls)))
                    (begin
                      (cons z (map1 (cdr ls)))
                    )
                )
              )
          )
        )
  )
)

; returns a satifiability associative list
(define f_isSatisfiable
  (lambda (head varList)
    (set! f_SATISFIED #f)
    (f_prettysat(mapish2 (f_isSat varList) head))
  )
)
     
; returns the satisfiability associative list in it's correct format
(define f_prettysat
  (lambda (sat)
        (if f_SATISFIED
            '(#t)
            (if (null? sat) 
                '(#f)
                (cons #t sat)
            )
        )
  )
)


; is can we choose x(Variable #t(or)#f)) and not contradict varList
(define possible
  (lambda (varList)
    (lambda (x)
      (define y '0)
      (set! y (returnTRUTH(car(getValue (car x) varList))))
      (if (eqv? y 'UNSET) (list #t x)
          (if (eq? y (car (cdr x))) (list #t 'SATISFIABLE) (list #f x))
      )
    )
  )
)

; returns a satifiability associative list
(define isSatisfiable
  (lambda (head valList)
    (makeSatList (map (possible valList) head))
  )
)

; returns #f if ls is unsatisfiable
; returns #t if ls is satisfiable
; returns #t ls2 if ls is satisfiable if we choose one element of ls2
;can make faster by changing the order of (cons #t (mapish iftrue ls))
(define makeSatList
  (lambda (ls)
    (if (eval (cons 'or (map car ls))) ; at least one true
        (if (member '(SATISFIABLE) (map cdr ls)) '(#t) (cons #t (mapish iftrue ls)))
        '(#f)
    )
  )
)

;*******************************************************************************************SEARCH AND BACKTRACK
; Search function
(define SEARCH
  (lambda (next open closed varList)
    (define sat 0)
    (define chosenPath 0)
    (define s_next 0)
    ;(pp (list '%%%%%%%%%%%%%%%SEARCH%%%%%%%%%%%%%%%%%%%%%))
    ;(pp (list 'b4next: next))
    ;(pp (list 'b4open: open))
    ;(pp (list 'b4clos: closed))
    ;(pp (list 'b4varl: varList))
    (set! sat (f_isSatisfiable next varList))
    ;(pp (list 'b4sati: sat))
    ;(pp (list '%%%%%%%%%%%%%%%SEARCH%%%%%%%%%%%%%%%%%%%%%))
    (if (and (car sat) (null? open))
        (if (null? (cdr sat)) 
            varList 
            (updateVarList(car(cdr sat)) varList)) ; found a solution
        (if (car sat) 
            (if (null? (cdr sat))
                ; statement is already true
                (begin
                 (set! s_next (chooseNext next open varList))
                 (SEARCH (car s_next) (car (cdr s_next)) (cons (cons '() (cons (list next) varList)) closed) varList)
                 )
                ; statement can be true if we choose something to be either true or false
                (begin
                  (set! s_next (chooseNext next open varList))
                  ;(pp s_next)
                  ;(pp (car s_next))
                  ;(pp (car(cdr s_next)))
                  (set! chosenPath (choosePath (cdr sat) open))
                  (SEARCH (car s_next) (car(cdr s_next)) (cons (cons (cdr chosenPath) (cons (list next) varList)) closed) (updateVarList(car chosenPath) varList))
                )
            )
            (begin
               ; under the current assumptions a solution is impossible 
                (BACKTRACK (cons next open) closed (car (car closed)) (cdr( cdr (car closed))) next) 
              )
           
        )
    )
  )
)

; backtracking function
(define BACKTRACK
  (lambda (open closed openPath varList unsatList)
    (define sat 0)
    (define chosenPath 0)
    (define s_next 0)
    
    (if (null? closed)
        #f ; can not backtrack any more - unsatisfiable
        (begin
          ;(pp (list '***************BACKTRACK******************))
          ;(pp (list 'open..: open))
          ;(pp (list 'closed: closed))
          ;(pp (list 'openPa: openPath ))
          ;(pp (list 'varLst: varList))
          ;(pp (list 'unsatL: unsatList))
          ;(pp (list '***************BACKTRACK******************))
          ;if we have an open path, and we have satisfiability for the unsatList - then we use one of the open paths, otherwise BACKTRACK
          (if (null? openPath) 
              (BACKTRACK (append(car (cdr (car closed))) open) (cdr closed) (car (car closed)) (cdr( cdr (car closed))) unsatList)
              (begin
                ;;;;;
                ;(pp (list 'evilsa: (f_isSatisfiable next varList)))
                (set! sat (f_isSatisfiable unsatList varList))
                ;(pp (list 'b4sati: sat))
                (if (car sat) 
                    (begin
                      (set! chosenPath (chooseBPath openPath open unsatList))
                      (begin
                        ;(display "$ ")
                        (apply SEARCH (append (chooseNext (car open) (cdr open) varList) (list (cons (cons (cdr chosenPath) (cons (list (car open)) varList)) closed) (updateVarList(car chosenPath) varList)))) 
                      )
                    )
                    (begin                      
                      (BACKTRACK (append(car (cdr (car closed))) open) (cdr closed) (car (car closed)) (cdr( cdr (car closed))) unsatList)
                      )
                )
              )
          )
        )
    )
  )
)
 


(define satisfy
  (lambda (test)
    (set! g_varList (constructvarlistplus test))
    (pp (apply SEARCH (append (chooseNext '() (Rephrase (cdr test)) g_varList) (list '((() (()) ())) g_varList))))
  )
)

(define main satisfy)